﻿<%@ import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="System.Globalization" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" codePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Tytuł wydruku</title>
		<script runat="server">

    public class _Info : ContextBase {
        public _Info(Context context) : base(context) {
            stanNaDzien = ((ActualDate)context[typeof(ActualDate)]).Actual;
        }

        Date stanNaDzien;
        [Priority(10)]
        [Caption("Dodatki na dzień")]
        public Date StanNaDzien {
            get { return stanNaDzien; }
            set {
                stanNaDzien = value;
                OnChanged(EventArgs.Empty);
            }
        }

        int iloscKopii = 1;
        [Priority(20)]
        [Caption("Ilość kopii")]
        public int IloscKopii {
            get { return iloscKopii; }
            set {
                if (value <= 0)
                    value = 1;
                iloscKopii = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    _Info info;
    [Context]
    public _Info Info {
        set { info = value; }
    }

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        bool pelneStanowisko = false;
        [Priority(1)]
        [Caption("Stanowisko pełna nazwa")]
        public bool PelneStanowisko {
            get { return pelneStanowisko; }
            set {
                pelneStanowisko = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		
	                		    
    void OnContextLoad(Object sender, EventArgs args) {
		PracHistoria ph = (PracHistoria)dc[typeof(PracHistoria)];
		
		Date data = info.StanNaDzien;

        string ss = "";

        //TID: 4851
        ss += "<li>Typ umowy o pracę: <b>" + CaptionAttribute.EnumToString(ph.Etat.TypUmowy).ToLower() + "</b></li>";

        ss += "<li>Wymiar czasu pracy: <b>" + ph.Etat.Zaszeregowanie.Wymiar + "</b></li>";

        ss += "<li>Stanowisko: <b>" + GetStanowisko(ph) + "</b></li>";

        ss += "<li>Wynagrodzenie zasadnicze w wysokości: <b>" + ph.Etat.Zaszeregowanie.Stawka.ToString("u", CultureInfo.CurrentCulture) + "</b> " + (ph.Etat.Zaszeregowanie.RodzajStawki == RodzajStawkiZaszeregowania.Miesieczna ? "miesięcznie" : "za godzinę") + "</li>";
        if (ph.Etat.Grupa != null)
            ss += "<li>Według grupy: <b>" + ph.Etat.Grupa.Nazwa + "</b></li>";

        foreach (Dodatek dodatek in ph.Pracownik.Dodatki) {
            DodHistoria dh = dodatek[data];
            if (dh.EfektywnyOkres.Contains(data) && dh.Element.Dodatkowe.DodatekDoEtatu) {
                ss += "<li>" + dodatek.Nazwa;
                string s2 = "";

                if (dh.Element.Algorytm.DodPodstawa != "")
                    s2 += ", " + dh.Element.Algorytm.DodPodstawa.ToLower() + " <b>" + dh.Podstawa.ToString("u", CultureInfo.CurrentCulture) + "</b>";

                if (dh.Element.Algorytm.DodProcent != "")
                    s2 += ", " + dh.Element.Algorytm.DodProcent.ToLower() + " <b>" + dh.Procent + "</b>";

                if (dh.Element.Algorytm.DodUlamek != "")
                    s2 += ", " + dh.Element.Algorytm.DodUlamek.ToLower() + " <b>" + dh.Ulamek + "</b>";

                if (s2 != "")
                    ss += " (" + s2.Substring(2) + ")";

                ss += "</li>";
            }
        }

        if (ss != "")
            ss = "<ul>" + ss + "</ul>";
		Skladniki.EditValue = ss;

        ArrayList al = new ArrayList();
        for (int i = 0; i < info.IloscKopii; i++)
            al.Add(ph);
        DataRepeater1.DataSource = al;
    }

    string GetStanowisko(PracHistoria ph) {
        string stanowiskoPelne = "";
        if (srpars.PelneStanowisko)
            stanowiskoPelne = ph.Etat.StanowiskoPełne;
        if (stanowiskoPelne.Length == 0)
            stanowiskoPelne = ph.Etat.Stanowisko;
        return stanowiskoPelne;
    }

    static object Msg(object value) {
        return value;
    }
		        
		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="form" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace"></ea:datacontext>
            <ea:DataRepeater ID="DataRepeater1" runat="server" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace" Width="100%" Height="161px">
            <ea:SectionMarker ID="SectionMarker9" runat="server"></ea:SectionMarker>
		    <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" 
				ResetPageCounter="True"></ea:PageBreak>
			<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="ANEKS DO UMOWY O PRACĘ" runat="server"></cc1:ReportHeader>
			<P>
				<TABLE id="Table1" cellSpacing="0" width="100%">
					<TR>
						<TD width="60%"><FONT face="Tahoma" size="2"></FONT></TD>
						<TD>
							<P align="center"><FONT face="Tahoma" size="2">.....................................................<BR>
									<FONT size="1">miejscowość i data</FONT></FONT></P>
						</TD>
					</TR>
					<TR>
						<TD width="60%">
							<ea:DataLabel id="DataLabel1" runat="server" DataMember="Plec" Bold="False">
								<ValuesMap>
									<ea:ValuesPair Key="Kobieta" Value="Pani"></ea:ValuesPair>
									<ea:ValuesPair Key="Mężczyzna" Value="Pan"></ea:ValuesPair>
								</ValuesMap>
							</ea:DataLabel><BR>
							<ea:DataLabel id="DataLabel3" runat="server" DataMember="Pracownik.ImięNazwisko"></ea:DataLabel><FONT face="Tahoma" size="2"></FONT></TD>
						<TD><FONT face="Tahoma"><BR>
								<FONT size="2"></FONT></FONT>
						</TD>
					</TR>
				</TABLE>
			</P>
			<P><FONT face="Tahoma" size="2">Aneks do umowy o pracę zawartej w dniu:
					<ea:DataLabel id="DataLabel9" runat="server" DataMember="Etat.DataZawarcia"></ea:DataLabel>.
				</FONT>
			</P>
			<P><FONT face="Tahoma" size="2">Pracodawca i pracownik zgodnie
                    oświadczają, że z dniem
					<ea:DataLabel id="DataLabel10" runat="server" DataMember="Aktualnosc.From"></ea:DataLabel>&nbsp;zmieniają postanowienia w/w umowy o pracę.</FONT></P>
            <p>
                <font face="Tahoma" size="2">Ustalają:</font></p>
					<FONT face="Tahoma" size="2">
						<ea:DataLabel id="Skladniki" runat="server" Bold="False">
						</ea:DataLabel>
					</FONT>
			<P><FONT face="Tahoma" size="2">Pozostałe warunki umowy o pracę nie ulegają zmianie.</FONT></P>
            <p>
                <font face="Tahoma" size="2">Aneks sporządzono w dwóch jednobrzmiących egzemplarzach po jednym dla każdej ze
                    stron.</font></p>
			<cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False">
				<Subtitles>
					<cc1:FooterSubtitle Caption="potwierdzenie odbioru przez pracownika - data i podpis" Width="50"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="podpis pracodawcy lub osoby reprezentującej pracodawcę albo osoby uprawnionej do składania oświadczeń w imieniu pracodawcy"
						Width="50"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:ReportFooter>
		<ea:SectionMarker ID="SectionMarker8" runat="server" SectionType="Footer"></ea:SectionMarker>
        </ea:DataRepeater>
		</form>
	</body>
</HTML>

